Option Explicit
'Constants
Const HKEY_CLASSES_ROOT 	= &H80000000
Const HKEY_CURRENT_USER 	= &H80000001
Const HKEY_LOCAL_MACHINE 	= &H80000002
Const HKEY_USERS 		= &H80000003
Const HKEY_CURRENT_CONFIG 	= &H80000005

'Variables
On Error resume next
Dim DataSourceName
Dim DatabaseName
Dim Description
Dim DriverPath
Dim LastUser
Dim Server
Dim Trusted_connection
Dim DriverName
Dim InputFile
Dim iFSO
Dim ifile
Dim sComputer
Dim sPath

'Value assignment

DataSourceName = "CRCUE_ODBC"
DatabaseName = "Crcue"
DriverPath = "C:\WINNT\System32\sqlsrv32.dll"
LastUser="sa"
Server="WINSQL2k"
Trusted_connection="Yes"
Description="ODBC DSN for the Database:" & DatabaseName
DriverName="SQL Server"
InputFile="c:\pclist.txt"
Set iFSO = CreateObject("Scripting.FilesyStemObject")
Set ifile = iFSO.OpenTextFile(inputfile)  
sPath		= "SOFTWARE\ODBC\ODBC.INI\" & DataSourceName 

'Read and loop through the input file
Do until ifile.AtEndOfLine
sComputer	= ifile.ReadLine
If (0 = CreateRegKey(sComputer, HKEY_LOCAL_MACHINE, sPath)) Then
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE, sPath, "Database", DatabaseName
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE, sPath, "Description", Description
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE, sPath, "Driver", DriverPath
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE, sPath, "LastUser",LastUser
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE, sPath, "Server",Server
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE, sPath, "Trusted_Connection",Trusted_connection
Else	
Exit Do	
End If	
'Write in "ODBC Data Sources" Key to allow ODBC Manager list & manage the new DSN
SetRegKeyStrValue sComputer, HKEY_LOCAL_MACHINE,  "SOFTWARE\ODBC\ODBC.INI\ODBC Data Sources", 
		DataSourceName , DriverName
MsgBox (sComputer & " DONE!")
 Loop 
 ifile.Close
 Set ifile = Nothing
 Set iFSO = Nothing

'Create RegKey Function

 Function CreateRegKey (sComputer, hTree, sKey)
Dim oRegistry
Dim lResult	
Set oRegistry	= GetObject("winmgmts:{impersonationLevel=impersonate}//" 
		& sComputer & "/root/default:StdRegProv")
lResult = oRegistry.CreateKey(hTree, sPath)
If (lResult = 0) And (Err.Number = 0) Then
CreateRegKey = 0
Else
CreateRegKey = 1
msgbox("Create Key " & sKey & " Failed")
End If
Set oRegistry = Nothing
End Function

'set RegKey Function

 Function SetRegKeyStrValue (sComputer, hTree, sKey, sValueName, sValue)
Dim oRegistry
Dim lResult	
Set oRegistry	= GetObject("winmgmts:{impersonationLevel=impersonate}//" 
		& sComputer & "/root/default:StdRegProv")
lResult = oRegistry.SetStringValue(hTree,   sKey,  sValueName,  sValue)
If (lResult = 0) And (Err.Number = 0) Then
SetRegKeyStrValue = 0
Else
SetRegKeyStrValue = 1
msgbox("Set Value for " & sKey & " Failed")
End If
Set oRegistry = Nothing
End Function

